VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ArmVSPRint"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SEP As String = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const C_ERRORRAISE As Long = 3000

Private Const FW_NORMAL = 400
Private Const DEFAULT_CHARSET = 1
Private Const OUT_DEFAULT_PRECIS = 0
Private Const CLIP_DEFAULT_PRECIS = 0
Private Const DEFAULT_QUALITY = 0
Private Const DEFAULT_PITCH = 0
Private Const FF_ROMAN = 16
Private Const CF_PRINTERFONTS = &H2
Private Const CF_SCREENFONTS = &H1
Private Const CF_BOTH = (CF_SCREENFONTS Or CF_PRINTERFONTS)
Private Const CF_EFFECTS = &H100&
Private Const CF_FORCEFONTEXIST = &H10000
Private Const CF_INITTOLOGFONTSTRUCT = &H40&
Private Const CF_LIMITSIZE = &H2000&
Private Const REGULAR_FONTTYPE = &H400
Private Const LF_FACESIZE = 32
Private Const CCHDEVICENAME = 32
Private Const CCHFORMNAME = 32
Private Const GMEM_MOVEABLE = &H2
Private Const GMEM_ZEROINIT = &H40
Private Const DM_DUPLEX = &H1000&
Private Const DM_ORIENTATION = &H1&
Private Const PD_PRINTSETUP = &H40
Private Const PD_DISABLEPRINTTOFILE = &H80000
Private Const PD_SELECTION As Long = &H1
Private Const PD_NOSELECTION As Long = &H4


      ' Constants for nIndex argument of GetDeviceCaps
Private Const HORZRES = 8
Private Const VERTRES = 10
Private Const LOGPIXELSX = 88
Private Const LOGPIXELSY = 90
Private Const PHYSICALWIDTH = 110
Private Const PHYSICALHEIGHT = 111
Private Const PHYSICALOFFSETX = 112
Private Const PHYSICALOFFSETY = 113

Private Const BORDER_NONE = 0
Private Const BORDER_LEFT = 1
Private Const BORDER_TOP = 2
Private Const BORDER_RIGHT = 4
Private Const BORDER_BOTTOM = 8
Private Const BORDER_OUTLINE = BORDER_LEFT Or BORDER_TOP Or BORDER_RIGHT Or BORDER_BOTTOM

Private Type POINTAPI
    x As Long
    y As Long
End Type

Private Type RECT
    Left As Long
    Top As Long
    right As Long
    bottom As Long
End Type

Private Type PAGESETUPDLG
    lStructSize As Long
    hwndOwner As Long
    hDevMode As Long
    hDevNames As Long
    flags As Long
    ptPaperSize As POINTAPI
    rtMinMargin As RECT
    rtMargin As RECT
    hInstance As Long
    lCustData As Long
    lpfnPageSetupHook As Long
    lpfnPagePaintHook As Long
    lpPageSetupTemplateName As String
    hPageSetupTemplate As Long
End Type

Private Type PRINTDLG_TYPE
    lStructSize As Long
    hwndOwner As Long
    hDevMode As Long
    hDevNames As Long
    hdc As Long
    flags As Long
    nFromPage As Integer
    nToPage As Integer
    nMinPage As Integer
    nMaxPage As Integer
    nCopies As Integer
    hInstance As Long
    lCustData As Long
    lpfnPrintHook As Long
    lpfnSetupHook As Long
    lpPrintTemplateName As String
    lpSetupTemplateName As String
    hPrintTemplate As Long
    hSetupTemplate As Long
End Type

Private Type DEVNAMES_TYPE
    wDriverOffset As Integer
    wDeviceOffset As Integer
    wOutputOffset As Integer
    wDefault As Integer
    extra As String * 256
End Type

Private Type DEVMODE_TYPE
    dmDeviceName As String * CCHDEVICENAME
    dmSpecVersion As Integer
    dmDriverVersion As Integer
    dmSize As Integer
    dmDriverExtra As Integer
    dmFields As Long
    dmOrientation As Integer
    dmPaperSize As Integer
    dmPaperLength As Integer
    dmPaperWidth As Integer
    dmScale As Integer
    dmCopies As Integer
    dmDefaultSource As Integer
    dmPrintQuality As Integer
    dmColor As Integer
    dmDuplex As Integer
    dmYResolution As Integer
    dmTTOption As Integer
    dmCollate As Integer
    dmFormName As String * CCHFORMNAME
    dmUnusedPadding As Integer
    dmBitsPerPel As Integer
    dmPelsWidth As Long
    dmPelsHeight As Long
    dmDisplayFlags As Long
    dmDisplayFrequency As Long
End Type

Private Type PRINTER_INFO
    TotalPrtAreaVert As Long
    TotalHeight  As Long
    MarginTop As Long
    MarginBottom As Long
    TotalPrtAreaHorz As Long
    TotalWidth As Long
    MarginLeft As Long
    MarginRight As Long
    CellMarginX As Long
    CellMarginY As Long
    CellHeight As Long
End Type

Private Declare Function PrintDialog Lib "comdlg32.dll" Alias "PrintDlgA" (pPrintdlg As PRINTDLG_TYPE) As Long
Private Declare Function PAGESETUPDLG Lib "comdlg32.dll" Alias "PageSetupDlgA" (pPagesetupdlg As PAGESETUPDLG) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
Private Declare Function GlobalLock Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function GlobalUnlock Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Sub Sleep Lib "kernel32" (ByVal dwMiliseconds As Long)
Private Declare Function GetDeviceCaps Lib "gdi32" (ByVal hdc As Long, ByVal nIndex As Long) As Long
'Private Declare Function ExtTextOut Lib "gdi32" Alias "ExtTextOutA" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal wOptions As Long, ByVal lpRect As Any, ByVal lpString As String, ByVal nCount As Long, lpDx As Long) As Long
Private Declare Function GetTextExtentPoint32 Lib "gdi32" Alias "GetTextExtentPoint32A" (ByVal hdc As Long, ByVal lpsz As String, ByVal cbString As Long, lpSize As POINTAPI) As Long
'Private Declare Function GetWindowDC Lib "user32" (ByVal hwnd As Long) As Long
'Private Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long
'Private Declare Function SetMapMode Lib "gdi32" (ByVal hdc As Long, ByVal nMapMode As Long) As Long
Private Declare Function DrawTextA Lib "user32.dll" (ByVal hdc As Long, ByVal lpStr As String, ByVal nCount As Long, lpRect As RECT, ByVal wFormat As Long) As Long
Private Declare Function DrawTextW Lib "user32.dll" ( _
     ByVal hdc As Long, _
     lpStr As Any, _
     ByVal nCount As Long, _
     ByRef lpRect As RECT, _
     ByVal wFormat As Long) As Long

Private Const DT_BOTTOM = &H8
Private Const DT_CALCRECT = &H400
Private Const DT_CENTER = &H1
Private Const DT_CHARSTREAM = 4 ' Character-stream, PLP
Private Const DT_DISPFILE = 6 ' Display-file
Private Const DT_EXPANDTABS = &H40
Private Const DT_EXTERNALLEADING = &H200
Private Const DT_INTERNAL = &H1000
Private Const DT_LEFT = &H0
Private Const DT_METAFILE = 5 ' Metafile, VDM
Private Const DT_NOCLIP = &H100
Private Const DT_NOPREFIX = &H800
Private Const DT_PLOTTER = 0 ' Vector plotter
Private Const DT_RASCAMERA = 3 ' Raster camera
Private Const DT_RASDISPLAY = 1 ' Raster display
Private Const DT_RASPRINTER = 2 ' Raster printer
Private Const DT_RIGHT = &H2
Private Const DT_SINGLELINE = &H20
Private Const DT_TABSTOP = &H80
Private Const DT_TOP = &H0
Private Const DT_VCENTER = &H4
Private Const DT_WORDBREAK = &H10

'Private mb_Initialized As Boolean
Private mo_Printer As VSPrinter
Private mo_Report As VSReport
Private ms_SerString As String
Private ms_FontName As String
Private ml_Charset As Long
Private mo_Data As New Collection
Private mo_FieldName As New Collection
Private ms_TempPrintFile As String

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1              ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2    ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3        ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301     ' detected row with same unique id
End Enum


'Set reference to VSPrinter component, which will displat print preview
Public Property Get VSPrinterRef() As VSPrinter
    Set VSPrinterRef = mo_Printer
End Property

Public Property Set VSPrinterRef(ByVal ao_Printer As VSPrinter)
    Set mo_Printer = ao_Printer
End Property

'Set reference to VSReport component, which will be able to load XML template.
Public Property Get VSReportRef() As VSReport
    Set VSReportRef = mo_Report
End Property

Public Property Set VSReportRef(ByVal ao_Report As VSReport)
    Set mo_Report = ao_Report
End Property

Public Property Get TempPrintFile() As String
    TempPrintFile = ms_TempPrintFile
End Property

Public Property Let TempPrintFile(ByVal as_TempPrintFile As String)
    ms_TempPrintFile = as_TempPrintFile
End Property

'Pass serialized data needed to fill the template
Public Property Get SerializedString() As String
    SerializedString = ms_SerString
End Property

Public Property Let SerializedString(ByVal as_Data As String)
On Error GoTo ErrHandler

    ms_SerString = as_Data
    Call SetString(as_Data)
    Exit Property
ErrHandler:
    Call ErrorHandler("SerializedString")
End Property

'Set font name for every field in report. If not specified, font from template will be used.
Public Property Get FontName() As String
    FontName = ms_FontName
End Property

Public Property Let FontName(ByVal as_Name As String)
    ms_FontName = as_Name
End Property

'Set charset of font for every field in report. If not specified, charset from template will be used.
Public Property Get Charset() As Long
    Charset = ml_Charset
End Property

Public Property Let Charset(ByVal al_Value As Long)
    ml_Charset = al_Value
End Property


'Initialize class, check if all needed properties are setup, allocate all resources. Init font name to "" and charset to -1.
Public Sub Load_A_Com()
On Error GoTo ErrHandler
    If mo_Printer Is Nothing Then Err.Raise ArmErr.CPTNotInitialized, "mo_Printer", "Printer property not initialized"
    If mo_Report Is Nothing Then Err.Raise ArmErr.CPTNotInitialized, "mo_Report", "Report property not initialized"
    ms_FontName = ""
    ml_Charset = 0
    Exit Sub
ErrHandler:
    Call ErrorHandler("Load_A_COM")
End Sub

'Deallocate resources, close all previews etc.
Public Sub Unload_A_Com()
On Error GoTo ErrHandler
    Set mo_Printer = Nothing
    Set mo_Report = Nothing
    Exit Sub
ErrHandler:
    Call ErrorHandler("Unload_A_COM")
End Sub

'Load xml template file into the "Report" component.
Public Function LoadTemplate(ByVal as_FileName As String, ByVal as_ReportName As String) As Boolean
On Error GoTo ErrHandler

    Call mo_Report.Clear
    Call mo_Report.Load(as_FileName, as_ReportName)
    Exit Function
ErrHandler:
    Call ErrorHandler("LoadTemplate")
End Function

'Parse serialized string, generate print preview using loaded template by the same way like in capture offer print preview.Preview will be displayed into VSPrint component passed as parameter to this class.
Public Function PrintPreview() As Boolean
On Error GoTo ErrHandler

    Call mo_Printer.Clear
    PrintPreview = ExecuteReport
    Exit Function
ErrHandler:
    Call ErrorHandler("PrintPreview")
End Function

'Send the print preview to printer, if printer device is not specified, show standard printer selection dialog.
Public Function PrintToPrinter(Optional ByVal as_PrinterDevice As String = "") As Boolean
On Error GoTo ErrHandler

    If as_PrinterDevice <> "" Then mo_Printer.Device = as_PrinterDevice
    Call mo_Printer.PrintDoc
    Exit Function
ErrHandler:
    Call ErrorHandler("PrintToPrinter")
End Function

'Send the print preview to file, this method can be used to generate the PDF file from preview using PDF printer.
Public Function PrintToFile(ByVal as_PrinterDevice As String, ByVal as_FileName As String) As Boolean
On Error GoTo ErrHandler

    Dim ld_StartTime As Date
#If LIVE Then
    Dim lo_FSO As Object
#Else
    Dim lo_FSO As FileSystemObject
#End If
    
    If ms_TempPrintFile = "" Then
        Err.Raise C_ERRORRAISE + 101, "ArmVSPrint", "Temporary print file not defined."
    End If
    
    Set lo_FSO = CreateObject("Scripting.FileSystemObject")
    
    mo_Printer.Device = as_PrinterDevice
    
    If lo_FSO.FileExists(ms_TempPrintFile) Then
        Call lo_FSO.DeleteFile(ms_TempPrintFile, True)
    End If
    
    Call mo_Printer.PrintDoc
    
    ld_StartTime = Now
    Do While Not lo_FSO.FileExists(ms_TempPrintFile)
        DoEvents
        Call Sleep(100)
        ' let's give 5 minutes to give up waiting.
        If DateDiff("n", ld_StartTime, Now) > 5 Then
            Exit Do
        End If
    Loop
    
    If Not lo_FSO.FileExists(ms_TempPrintFile) Then
        Err.Raise C_ERRORRAISE + 102, "ArmVSPrint", "Unable to find the '" & ms_TempPrintFile & "' file generated by" & as_PrinterDevice
    End If
         
    Call lo_FSO.CopyFile(ms_TempPrintFile, as_FileName, True)
    
    Call lo_FSO.DeleteFile(ms_TempPrintFile)
    
    Set lo_FSO = Nothing
        
    PrintToFile = True
    Exit Function
ErrHandler:
    Set lo_FSO = Nothing
    Call ErrorHandler("PrintToFile")
End Function

'Private Function ExecuteReport(ByVal as_PathReport As String, ByVal as_COS_ID As String, ByVal as_COF_ID As String, ByVal al_COT_ID, ByVal as_Report_Language As String, ByVal al_Report_CodePage As Long, ByVal as_ss As String) As Boolean
Private Function ExecuteReport() As Boolean
On Error GoTo ErrHandler

    Dim ll_Index As Long
    Dim ll_Index2 As Long
    
    If ms_FontName <> "" Then
        mo_Report.Font.Name = ms_FontName
        mo_Printer.Font.Name = ms_FontName
    End If
    If ml_Charset <> 0 Then
        mo_Report.Font.Charset = ml_Charset
        mo_Printer.Font.Charset = ml_Charset
    End If
    
    'vp.Orientation = orPortrait
    mo_Printer.PaperSize = pprA4
    mo_Printer.MarginLeft = 800
    mo_Printer.MarginRight = 800
    mo_Printer.MarginTop = 800
    mo_Printer.MarginBottom = 800
    
    mo_Printer.CurrentX = mo_Printer.MarginLeft
    mo_Printer.CurrentY = mo_Printer.MarginTop
    
    
    For ll_Index = 0 To mo_Report.Fields.Count - 1
        If Not mo_Report.Fields.Item(ll_Index).Subreport Is Nothing Then
            Call FillInSubreport(ll_Index)
        End If
        
        ' replace data for item itself P.150
        mo_Report.Fields.Item(ll_Index).Text = ReplaceData(mo_Report.Fields.Item(ll_Index).Text, 0)
    Next ll_Index
    
    If ms_FontName <> "" Then
        For ll_Index = 1 To mo_Report.Fields.Count - 1
            If Not mo_Report.Fields(ll_Index).Subreport Is Nothing Then
                For ll_Index2 = 0 To mo_Report.Fields(ll_Index).Subreport.Fields.Count - 1
                    If Not mo_Report.Fields(ll_Index).Subreport.Fields(ll_Index2).Font Is Nothing Then
                        mo_Report.Fields(ll_Index).Subreport.Fields(ll_Index2).Font.Name = ms_FontName
                        mo_Report.Fields(ll_Index).Subreport.Fields(ll_Index2).Font.Charset = ml_Charset
                    End If
                Next ll_Index2
            End If
        Next
    End If
    
    Call mo_Report.Render(mo_Printer)
    ExecuteReport = True
    Exit Function
ErrHandler:
    Call ErrorHandler("ExecuteReport")
End Function

Private Sub FillInSubreport(ByVal al_ReportID As Long)
On Error GoTo ErrHandler

    Dim ll_Row As Long
    Dim ll_RowCount As Long
    Dim ll_Field As Long
    Dim ll_RptField  As Long

'    Dim ls_Data As String
'    Dim ls_FieldName As String
    Dim ls_Text As String

    Dim ll_DetailHeight As Long
    Dim ll_AddHeight As Long

    ll_AddHeight = 0

    If mo_Report.Fields.Item(al_ReportID).Subreport.Sections.Count >= 6 Then
        ll_AddHeight = mo_Report.Fields(al_ReportID).Subreport.Sections(5).Height
    End If

    Dim lo_Fields As Collection
    Dim ll_Index As Long

    'Get the fields for Detail Section
    Set lo_Fields = New Collection
    For ll_Index = 0 To mo_Report.Fields.Item(al_ReportID).Subreport.Sections(0).Fields.Count - 1
        Call lo_Fields.Add(mo_Report.Fields.Item(al_ReportID).Subreport.Sections(0).Fields(ll_Index))
    Next
    ll_RowCount = GetRowCount(lo_Fields)

    'Delete all the fields from Detail Section
    While mo_Report.Fields.Item(al_ReportID).Subreport.Sections(0).Fields.Count <> 0
        Call mo_Report.Fields.Item(al_ReportID).Subreport.Sections(0).Fields.Remove(0)
    Wend

    ll_DetailHeight = mo_Report.Fields(al_ReportID).Subreport.Sections(0).Height

    For ll_Row = 0 To ll_RowCount - 1

        For ll_RptField = 0 To lo_Fields.Count - 1
            ls_Text = ReplaceData(lo_Fields(ll_RptField + 1).Text, ll_Row)

            'Create the report field
            Call mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Add(lo_Fields(ll_RptField + 1).Name, ls_Text, lo_Fields(ll_RptField + 1).Left, lo_Fields(ll_RptField + 1).Top + ll_AddHeight, lo_Fields(ll_RptField + 1).Width, lo_Fields(ll_RptField + 1).Height)

            'Format the report field
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).ALIGN = lo_Fields(ll_RptField + 1).ALIGN
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).CanGrow = lo_Fields(ll_RptField + 1).CanGrow
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).CanShrink = lo_Fields(ll_RptField + 1).CanShrink
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).Font = lo_Fields(ll_RptField + 1).Font
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).BorderStyle = lo_Fields(ll_RptField + 1).BorderStyle
            
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).ForcePageBreak = lo_Fields(ll_RptField + 1).ForcePageBreak
            
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).MarginTop = lo_Fields(ll_RptField + 1).MarginTop
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).MarginLeft = lo_Fields(ll_RptField + 1).MarginLeft
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).MarginRight = lo_Fields(ll_RptField + 1).MarginRight
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).MarginBottom = lo_Fields(ll_RptField + 1).MarginBottom
            
        Next ll_RptField

        ll_AddHeight = ll_AddHeight + ll_DetailHeight

    Next ll_Row

    Set lo_Fields = Nothing

    If mo_Report.Fields.Item(al_ReportID).Subreport.Sections.Count >= 6 Then
        'this is to put the group header into the detail part (to display columns headers)
        Set lo_Fields = New Collection
        For ll_Index = 0 To mo_Report.Fields.Item(al_ReportID).Subreport.Sections(5).Fields.Count - 1
            Call lo_Fields.Add(mo_Report.Fields.Item(al_ReportID).Subreport.Sections(5).Fields(ll_Index))
        Next

        'Delete all the fields
        While mo_Report.Fields.Item(al_ReportID).Subreport.Sections(5).Fields.Count <> 0
            Call mo_Report.Fields.Item(al_ReportID).Subreport.Sections(5).Fields.Remove(0)
        Wend

        For ll_Index = 0 To lo_Fields.Count - 1
            'Create the report field
            Call mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Add(lo_Fields(ll_Index + 1).Name, lo_Fields(ll_Index + 1).Text, lo_Fields(ll_Index + 1).Left, lo_Fields(ll_Index + 1).Top, lo_Fields(ll_Index + 1).Width, lo_Fields(ll_Index + 1).Height)

            'Format the report field
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).ALIGN = lo_Fields(ll_Index + 1).ALIGN
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).CanGrow = lo_Fields(ll_Index + 1).CanGrow
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).CanShrink = lo_Fields(ll_Index + 1).CanShrink
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).Font = lo_Fields(ll_Index + 1).Font
            mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields(mo_Report.Fields(al_ReportID).Subreport.Sections(0).Fields.Count - 1).BorderStyle = lo_Fields(ll_Index + 1).BorderStyle
        Next
        Set lo_Fields = Nothing

    End If

    Exit Sub
ErrHandler:
    Set lo_Fields = Nothing
    Call ErrorHandler("FillInSubreports")
End Sub

Private Function ReplaceData(as_String As String, al_Row As Long) As String
On Error GoTo ErrHandler
    Dim ll_Field As Long
    Dim ls_Data As String
    Dim ls_FieldName  As String
    
    
    For ll_Field = 0 To mo_Data.Count - 1
        ' see if data is in serialized string
        ls_Data = GetData(ll_Field, al_Row)
        ls_FieldName = GetFieldName(ll_Field)
        as_String = Replace(as_String, "[" & ls_FieldName & "]", ls_Data, , , vbTextCompare)
    Next ll_Field

    ReplaceData = as_String
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplaceData")
End Function
Private Function GetRowCount(ByVal ao_Fields As Collection) As Long
On Error GoTo ErrHandler
Dim ls_Data() As String
Dim ll_RowCount As Long
Dim ll_FieldIdx As Long, ll_DataIdx As Long

    ll_RowCount = 1
    For ll_FieldIdx = 1 To ao_Fields.Count
        For ll_DataIdx = 1 To mo_FieldName.Count
            If InStr(1, ao_Fields(ll_FieldIdx).Text, "[" & mo_FieldName(ll_DataIdx) & "]", vbTextCompare) > 0 Then
                ls_Data = Split(mo_Data(ll_DataIdx), SEP1)
                If UBound(ls_Data) + 1 > ll_RowCount Then ll_RowCount = UBound(ls_Data) + 1
            End If
        Next ll_DataIdx
    Next ll_FieldIdx
    GetRowCount = ll_RowCount
    Exit Function
ErrHandler:
    Call ErrorHandler("GetRowCount")
End Function

Private Function GetData(ByVal al_Index As Long, ByVal al_Row As Long) As String
On Error GoTo ErrHandler
Dim ls_Data() As String

    ls_Data = Split(mo_Data(al_Index + 1), SEP1)
    If al_Row <= UBound(ls_Data) Then
        GetData = ls_Data(al_Row)
    Else
        GetData = ""
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetData")
End Function

Private Function GetFieldName(ByVal al_Index As Long) As String
On Error GoTo ErrHandler

    GetFieldName = mo_FieldName(al_Index + 1)
    Exit Function
ErrHandler:
    Call ErrorHandler("GetFieldName")
End Function

Private Sub SetString(ByVal as_Data As String)
On Error GoTo ErrHandler

Dim lv_Data As Variant
Dim lv_Element As Variant, ls_Data As String, ls_Field As String
Dim ll_DataIdx As Long

    Call ClearCollection(mo_Data)
    Call ClearCollection(mo_FieldName)
    lv_Data = Split(as_Data, SEP)
    For Each lv_Element In lv_Data
        ll_DataIdx = InStr(1, lv_Element, SEP1)
        If ll_DataIdx > 1 Then
            ls_Field = Left(lv_Element, ll_DataIdx - 1)
            ls_Data = Mid(lv_Element, ll_DataIdx + 1)
            Call mo_FieldName.Add(ls_Field)
            Call mo_Data.Add(ls_Data, ls_Field)
        Else
            Call mo_FieldName.Add(Str(lv_Element))
            Call mo_Data.Add("", Str(lv_Element))
        End If
    Next
Exit Sub
ErrHandler:
    Call ErrorHandler("SetString")
End Sub

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long
On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select

    Exit Function
ErrHandler:
    Call ErrorHandler("SetString")
End Function

Public Function SelectPrinterDlg(ByVal frmOwner As Form, Optional ByRef al_PrintFlags As Long = 0) As Boolean
    Dim PrintDlg As PRINTDLG_TYPE
    Dim DevMode As DEVMODE_TYPE
    Dim DevName As DEVNAMES_TYPE
    Dim ll_PrintResult As Long

    Dim lpDevMode As Long, lpDevName As Long
    Dim bReturn As Integer
    Dim objPrinter As Printer, NewPrinterName As String
    
On Error GoTo ErrHandler
    SelectPrinterDlg = False
    ' Use PrintDialog to get the handle to a memory
    ' block with a DevMode and DevName structures

    PrintDlg.lStructSize = Len(PrintDlg)
    If Not (frmOwner Is Nothing) Then
        PrintDlg.hwndOwner = frmOwner.hwnd
    End If

    PrintDlg.flags = al_PrintFlags
    On Error Resume Next
    'Set the current orientation and duplex setting
    DevMode.dmDeviceName = Printer.DeviceName
    DevMode.dmSize = Len(DevMode)
    DevMode.dmFields = DM_ORIENTATION Or DM_DUPLEX
    DevMode.dmPaperWidth = Printer.Width
    DevMode.dmOrientation = Printer.Orientation
    DevMode.dmPaperSize = Printer.PaperSize
    DevMode.dmDuplex = Printer.Duplex
    On Error GoTo 0

    'Allocate memory for the initialization hDevMode structure
    'and copy the settings gathered above into this memory
    PrintDlg.hDevMode = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, Len(DevMode))
    If PrintDlg.hDevMode = 0 Then Err.Raise -100, "GlobalAlloc", "GlobalAlloc failed: Len(DevMode)=" & Len(DevMode)
    
    lpDevMode = GlobalLock(PrintDlg.hDevMode)
    If lpDevMode = 0 Then
      Err.Raise -110, "GlobalLock", "GlobalLock failed"
    Else
        CopyMemory ByVal lpDevMode, DevMode, Len(DevMode)
        bReturn = GlobalUnlock(PrintDlg.hDevMode)
    End If

    'Set the current driver, device, and port name strings
    With DevName
        .wDriverOffset = 8
        .wDeviceOffset = .wDriverOffset + 1 + Len(Printer.DriverName)
        .wOutputOffset = .wDeviceOffset + 1 + Len(Printer.Port)
        .wDefault = 0
    End With

    With Printer
        DevName.extra = .DriverName & Chr(0) & .DeviceName & Chr(0) & .Port & Chr(0)
    End With

    'Allocate memory for the initial hDevName structure
    'and copy the settings gathered above into this memory
    PrintDlg.hDevNames = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, Len(DevName))
    If PrintDlg.hDevNames = 0 Then Err.Raise -120, "GlobalAlloc", "GlobalAlloc failed: Len(DevName)=" & Len(DevName)
    
    lpDevName = GlobalLock(PrintDlg.hDevNames)
    If lpDevName = 0 Then
      Err.Raise -100, "GlobalLock", "GlobalLock failed"
    Else
        CopyMemory ByVal lpDevName, DevName, Len(DevName)
        bReturn = GlobalUnlock(lpDevName)
    End If

    'Call the print dialog up and let the user make changes
    ll_PrintResult = PrintDialog(PrintDlg)
    
    'First get the DevName structure.
    lpDevName = GlobalLock(PrintDlg.hDevNames)
    If lpDevName = 0 Then
      Err.Raise -130, "GlobalLock", "GlobalLock failed"
    Else
      CopyMemory DevName, ByVal lpDevName, Len(DevName)
      bReturn = GlobalUnlock(lpDevName)
    End If
    Call GlobalFree(PrintDlg.hDevNames)
    PrintDlg.hDevNames = 0
    
    'Next get the DevMode structure and set the printer
    'properties appropriately
    lpDevMode = GlobalLock(PrintDlg.hDevMode)
    If lpDevMode = 0 Then
      Err.Raise -100, "GlobalLock", "GlobalLock failed"
    Else
      Call CopyMemory(DevMode, ByVal lpDevMode, Len(DevMode))
      bReturn = GlobalUnlock(PrintDlg.hDevMode)
    End If
    Call GlobalFree(PrintDlg.hDevMode)
    PrintDlg.hDevMode = 0
    
    If ll_PrintResult <> 0 Then

        NewPrinterName = right(DevName.extra, Len(DevName.extra) - (DevName.wDeviceOffset - 8))
        NewPrinterName = Left(NewPrinterName, InStr(NewPrinterName, Chr$(0)) - 1)
        If StrComp(Printer.DeviceName, NewPrinterName, vbTextCompare) <> 0 Then
            For Each objPrinter In Printers
                ' I have no idea how to get full device name (not limited to CCHDEVICENAME - 2) even I have no idea why there must be -2 and not -1
                If StrComp(objPrinter.DeviceName, NewPrinterName, vbTextCompare) = 0 Then
                    Set Printer = objPrinter
                    Exit For
                End If
            Next
        End If

        On Error Resume Next
        'Set printer object properties according to selections made
        'by user
        Printer.Copies = DevMode.dmCopies
        Printer.Duplex = DevMode.dmDuplex
        Printer.Orientation = DevMode.dmOrientation
        Printer.PaperSize = DevMode.dmPaperSize
        Printer.PrintQuality = DevMode.dmPrintQuality
        Printer.ColorMode = DevMode.dmColor
        Printer.PaperBin = DevMode.dmDefaultSource
        al_PrintFlags = PrintDlg.flags
        SelectPrinterDlg = True
        On Error GoTo 0
    End If
  Exit Function
ErrHandler:
    If PrintDlg.hDevNames <> 0 Then Call GlobalFree(PrintDlg.hDevNames)
    If PrintDlg.hDevMode <> 0 Then Call GlobalFree(PrintDlg.hDevMode)
    Call ErrorHandler("SelectPrinterDlg")
End Function

Private Sub ClearCollection(ByVal ao_Collection As Collection)
On Error GoTo ErrHandler

    While ao_Collection.Count > 0
        Call ao_Collection.Remove(1)
    Wend
    Exit Sub
ErrHandler:
    Call ErrorHandler("ClearCollection")
End Sub

Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

